local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
--local Pulse = THEME:GetMetric("Combo", "PulseCommand");

-- yes I'm hardcoding it here. I don't like messing with the convoluted
-- metrics.ini any more than I have to. Yes, this puts me into the bucket of
-- "new school theming" despite being as "old school" as 2004, during the
-- Golden Age of Theming. The new school will take SM theming out of the dark
-- ages, hopefully.
local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

local t = Def.ActorFrame {
	LoadFont( "Combo", "numbers" ) .. {
		Name="Number";
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};
	LoadFont( "Combo", "numbers" ) .. {
		Name="Number2";
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};
	LoadActor("_label") .. {
		Name="ComboLabel";
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};
	InitCommand = function(self)
		c = self:GetChildren();
		c.Number:visible(false);
		c.ComboLabel:visible(false);
	end;

	-- TOTO: find out why the miss label/number shows up on goods; technically
	-- they shouldn't be showing up, I think.
	ComboCommand=function(self, param)
		local iCombo = param.Misses or param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			c.Number:visible(false);
			c.Number2:visible(false);
			c.ComboLabel:visible(false);
			return;
		end

		local Label = c.ComboLabel;
		local bComboOrMiss = false;
		if param.Combo then
			--Label:diffuse( color("#FFFFFF") );
			Label:diffusebottomedge( PlayerColor(player) );
			bComboOrMiss = true;
		elseif param.Misses then
			--Label:diffuse( color("#FF0000") );
			Label:diffusebottomedge( color("#FF0000") );
			bComboOrMiss = true;
		end
		-- reset the label's visibility so we don't accidentally draw both labels
		Label:visible(false);

		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );
		
		if bComboOrMiss then
			c.Number:visible(true);
			c.Number2:visible(true);
			Label:visible(true);
		end;

		c.Number:settext( string.format("%i", iCombo) );
		c.Number:diffuse( PlayerColor(player) );
		--c.Number:diffusebottomedge( PlayerColor(player) );
		
		-- set up the add
		c.Number2:settext( string.format("%i", iCombo) );
		c.Number2:diffuse( PlayerColor(player) );
		c.Number2:blend('BlendMode_Add');
		c.Number2:diffusealpha(0.1); -- old value: 0.15
		
		-- this function glows the combo number.
		local Pulse = function(self)
			self:stoptweening();
				
			local GlowStart;
			local GlowEnd;
			local StartAlpha = 0.5;
			if param.Combo then
				GlowColor = color("1,1,1,"..StartAlpha);
				GlowEnd = color("1,1,1,0");
			else
				GlowColor = color("1,0,0,"..StartAlpha);
				GlowEnd = color("1,0,0,0");
			end;
			
			self:glow(GlowColor);
			self:smooth(0.1);
			self:glow(GlowEnd);
		end;
		
		Pulse( c.Number, param );
	end;
};

return t;
